-- Newgame postprocessor script for the ICE mod.

for pi,p in pairs(get_players()) do

 -- HIGH-G Homeworld is +1 size for all players.
 -- Medium becomes Large; Large becomes Huge.
    if p.highg_world == 1 then
        if p.large_hw == 1 then
            set_planets({[p.home_planet] = {size = 4}}) else
            set_planets({[p.home_planet] = {size = 3}})
        end
    end

 -- LUCKY races get gold deposits on the HW.    
    if p.lucky == 1 then
        set_planets({[p.home_planet] = {special = 4}})
    end

 -- Homeworld for LOW-G Gnolam AI is SMALL GAIA.
 -- LOW-G + Lucky (3 picks) = 16pop GAIA.
 -- LOW-G + Large (2 picks) = 18pop TERRAN.
    if p.lucky == 1 and p.lowg_world == 1 and p.is_human == 0 then
        set_planets({[p.home_planet] = {size = 1, food_base = 6, climate = 9}})
    end

 -- UNCREATIVE: Remove shield specials from the tech tree if it does not contain at least 1 ship shield.
    if p.uncreative == 1 then
        t = get_player_techs(pi)
        if t.class_i_shield == 0 and t.class_iii_shield == 0 and t.class_v_shield == 0 and t.class_vii_shield == 0 and t.class_x_shield == 0 then
            if t.shield_capacitors == 1 then
            t.shield_capacitors = 0
            r = random(2)
                if r == 1 then
                    t.inertial_stabilizer = 1 t.tractor_beam = 0 else
                    t.inertial_stabilizer = 0 t.tractor_beam = 1
                end
            end
            if t.multi_phased_shields == 1 then
            t.multi_phased_shields = 0
            r = random(2)
                if r == 1 then
                    t.stealth_field = 1 t.warp_dissipator = 0 else
                    t.stealth_field = 0 t.warp_dissipator = 1
                end
            end
            if t.hard_shields == 1 then
            t.hard_shields = 0
            r = random(2)
                if r == 1 and t.extended_fuel_tanks == 1 then
                    t.cloaking_device = 1 t.warp_interdictor = 0 else
                    t.cloaking_device = 0 t.warp_interdictor = 1
                end
            end
        end
        set_player_techs(pi, t)
    end

end
